
  document.addEventListener('DOMContentLoaded', () => {
    const container = document.querySelector('.aryslide-button-container');
    const buttons = container.querySelectorAll('.aryslide-button');
    const buttonHeight = buttons[0]?.offsetHeight + 10; // +10px for the gap
    let scrollPosition = 0;

    setInterval(() => {
      scrollPosition += buttonHeight;

      // If reached bottom, reset to top
      if (scrollPosition >= container.scrollHeight - container.clientHeight) {
        scrollPosition = 0;
      }

      container.scrollTo({
        top: scrollPosition,
        behavior: 'smooth'
      });
    }, 10000); // 600ms wait between scrolls
  });


//   lazy loading images

const lazyBackgrounds = document.querySelectorAll('.lazy-bg');

const observer = new IntersectionObserver(entries => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.style.backgroundImage = `url('${entry.target.dataset.bg}')`;
      entry.target.classList.add('loaded');
    }
  });
});

lazyBackgrounds.forEach(bg => observer.observe(bg));
