document.addEventListener("DOMContentLoaded", function() {
    updateOneDimensions(); // Set default dimensions on page load
});

document.getElementById("dimensionSelect").addEventListener("change", function() {
    updateOneDimensions(); // Update dimensions when selection changes

    const imageInput = document.getElementById("img1");

    if (imageInput.files.length > 0) {
        validateOneImage(imageInput, "img1Preview", "img1Label");
    }
});

function updateOneDimensions() {
    const dimensionSelect = document.getElementById("dimensionSelect").value.split("x");
    window.allowedWidth = parseInt(dimensionSelect[0], 10);
    window.allowedHeight = parseInt(dimensionSelect[1], 10);
}

function validateOneImage(input, previewId, labelId) {
    const file = input.files[0];
    const previewContainer = document.getElementById(previewId);
    const label = document.getElementById(labelId);
    const submitButton = document.getElementById("submitButton");

    const allowance = 50;

    if (!file) {
        label.textContent = "❌ Please select an image.";
        previewContainer.innerHTML = "";
        submitButton.disabled = true;
        return;
    }

    if (!file.type.startsWith("image/")) {
        label.textContent = "❌ Invalid file type! Please upload an image.";
        previewContainer.innerHTML = "";
        submitButton.disabled = true;
        return;
    }

    const img = new Image();
    img.src = URL.createObjectURL(file);

    img.onload = function () {
        const width = img.width;
        const height = img.height;

        if (
            width >= window.allowedWidth - allowance && width <= window.allowedWidth + allowance &&
            height >= window.allowedHeight - allowance && height <= window.allowedHeight + allowance
        ) {
            label.textContent = `✅ Image size is valid (${width}x${height}px).`;
            previewContainer.innerHTML = `<img src="${img.src}" style="max-width: 100%; max-height: 200px; border: 1px solid #ddd;">`;
            submitButton.disabled = false;
        } else {
            label.textContent = `❌ Invalid size! Expected ${window.allowedWidth}x${window.allowedHeight}px (±${allowance}px).`;
            previewContainer.innerHTML = "";
            submitButton.disabled = true;
        }
    };
}



