function updatePresetDimensions() {
    const dimensionSelect = document.getElementById("dimensionSelect").value.split("x");
    const allowedWidth = parseInt(dimensionSelect[0], 10);
    const allowedHeight = parseInt(dimensionSelect[1], 10);
    return { allowedWidth, allowedHeight };
}

function validateImage(input, previewId, labelId) {
    const file = input.files[0];
    const previewContainer = document.getElementById(previewId);
    const label = document.getElementById(labelId);
    const submitButton = document.getElementById("submitButton");

    const { allowedWidth, allowedHeight } = updatePresetDimensions();
    const allowance = 30; // ±30px flexibility

    if (!file) {
        label.textContent = "❌ Please select an image.";
        previewContainer.innerHTML = "";
        submitButton.disabled = true;
        return;
    }

    if (!file.type.startsWith("image/")) {
        label.textContent = "❌ Invalid file type! Please upload an image.";
        previewContainer.innerHTML = "";
        submitButton.disabled = true;
        return;
    }

    const img = new Image();
    img.src = URL.createObjectURL(file);

    img.onload = function () {
        const width = img.width;
        const height = img.height;

        if (
            width >= allowedWidth - allowance && width <= allowedWidth + allowance &&
            height >= allowedHeight - allowance && height <= allowedHeight + allowance
        ) {
            label.textContent = `✅ Image size is valid (${width}x${height}px).`;
            previewContainer.innerHTML = `<img src="${img.src}" style="max-width: 100%; max-height: 200px; border: 1px solid #ddd;">`;
            submitButton.disabled = false;
        } else {
            label.textContent = `❌ Invalid size! Expected ${allowedWidth}x${allowedHeight}px (±${allowance}px).`;
            previewContainer.innerHTML = "";
            submitButton.disabled = true;
        }
    };
}
