
//   for images upload

    let presetWidth = 500; // Default preset width
    let presetHeight = 300; // Default preset height
    const range = 10; // Allowed difference in pixels
    let validationResults = { img1: false, img2: false, img3: false };

    // Update dimensions when dropdown changes
    function updatePresetDimensions() {
        const selectedValue = document.getElementById('dimensionSelect').value;
        const dimensions = selectedValue.split('x');
        presetWidth = parseInt(dimensions[0]);
        presetHeight = parseInt(dimensions[1]);

        // Re-validate images if any are already uploaded
        ['img1', 'img2', 'img3'].forEach(id => {
            const input = document.getElementById(id);
            if (input && input.files && input.files[0]) {
                validateImage(input, `${id}Preview`, `${id}Label`);
            }
        });
    }



    // Validate each image
    function validateImage(input, previewId, labelId) {
        const previewDiv = document.getElementById(previewId);
        const label = document.getElementById(labelId);
        const submitButton = document.getElementById('submitButton');

        previewDiv.innerHTML = ''; // Clear previous content
        label.innerHTML = ''; // Clear previous validation result

        if (input.files && input.files[0]) {
            const file = input.files[0];
            const reader = new FileReader();

            reader.onload = function (e) {
                const img = new Image();
                img.src = e.target.result;

                img.onload = function () {
                    const width = img.width;
                    const height = img.height;

                    // Display the image preview
                    previewDiv.innerHTML = `<img src="${img.src}" alt="Image preview" style="max-width: 100px; height: auto;"/>`;

                    // Display actual and expected dimensions
                    const dimensionsMessage = `
                        <p>Actual Dimensions: ${width}px x ${height}px</p>
                        <p>Expected Dimensions: ${presetWidth}px x ${presetHeight}px</p>
                    `;
                    previewDiv.innerHTML += dimensionsMessage;

                    // Validate dimensions
                    const widthDiff = Math.abs(width - presetWidth);
                    const heightDiff = Math.abs(height - presetHeight);
                    const passed = widthDiff <= range && heightDiff <= range;

                    // Update validation result and label
                    validationResults[input.id] = passed;
                    label.innerHTML = passed
                        ? `<span style="color: green;">Passed</span>`
                        : `<span style="color: red;">Failed</span>`;

                    // Check overall validation
                    submitButton.disabled = !Object.values(validationResults).every(result => result);
                };
            };

            reader.readAsDataURL(file); // Read the file as a data URL
        } else {
            previewDiv.innerHTML = '<p>No file chosen.</p>';
            label.innerHTML = '<span style="color: red;">Failed</span>';
            validationResults[input.id] = false;
            submitButton.disabled = true; // Disable submit button
        }
    }

